/*******************************************************
Filename		:  	DW_proj_popup.sql
Release 		:  	STORET C2.0, 2.0.5
SIR			:  	1442, 1707
Description		:  	Displays a list of projects that correspond to the selected
				organization and allows the user to select one. The value is 
				returned to the Project Result Criteria page.
Author			:  	Joseph Wilson
Date			: 	March 18, 2003  -- added project ID to screen; reformatted top
				03/24/2003 - Updated table and column names to work with updated ETL. -J Wilson
				04/11/2003 - Changed format of project list. -C Tsang
				06/20/2005 - Modified for support of National Projects. -S. Smith
Comments		:  	Project name is passed to a text area on the Project Result Selection Criteria page.  
				The project code is passed to a hidden text field.  Uses the passback() function in DW_storet.js.
**********************************************************/
CREATE or REPLACE PROCEDURE DW_PROJ_POPUP (v_org number,v_org_name varchar2 default null) AS 
v_OrgName varchar2(60);
script_path varchar2(1000);
nproj_name di_project.project_name%type;

CURSOR cproj IS
	SELECT pk_isn, project_cd, project_name
	FROM DI_PROJECT
	where fk_org = v_org
	order by project_cd;

CURSOR cproj_nat IS
	SELECT count(project_cd) IDC, project_cd, min(pk_isn) min_pk_isn from
	DI_PROJECT group by project_cd order by project_cd;


BEGIN
script_path := DW_glob_var.lv_script_path;

IF v_org = -1 THEN
--  v_OrgName := 'All Organizations';
  v_OrgName := v_org_name;
ELSE
  select organization_name into v_OrgName
  From di_org
  where pk_isn = v_org;
END IF;
 
htp.htmlOpen;
htp.headOpen;
htp.print('<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">');
htp.title( 'STORET: Select a Project');
htp.print('<SCRIPT LANGUAGE="JavaScript1.2" SRC='||script_path||'>');
htp.print( '</SCRIPT>' );
htp.print('<basefont face="Arial, Helvetica, sans-serif" size="2">');
htp.headClose;
--htp.bodyOpen( 'onload="document.forms[0].D_PROJ_LIST.selectedIndex = -1"');
htp.print('<BODY onload=adjust_width_n(document.forms[0].D_PROJ_LIST,"~","15~60","None","N");>');
htp.print( '<b>Select a Project for the Organization: '||v_OrgName||'</b><br>' );
htp.PRINT('<form name="select_proj">');
htp.PRINT('<font face="Courier">');
htp.formSelectOpen('D_PROJ_LIST', nsize => '10', cattributes => 'tabindex=25 style="font:  10pt/12pt COURIER"'); 
htp.formSelectOption('Project ID~Project Name', cattributes => 'VALUE=0');
htp.formSelectOption('_______________________________________________________________________________',cattributes => 'VALUE=0');

IF v_org = -1 THEN
	FOR proj IN cproj_nat LOOP
--		if proj.IDC > 1 then
		if proj.IDC >= DW_glob_var.national_project_criteria then
			select project_name into nproj_name from DI_PROJECT where pk_isn = proj.min_pk_isn;
			if length(nproj_name) < 35 then nproj_name := nproj_name||')';
				else nproj_name := substr(nproj_name,1,32)||'...'; end if;
        		htp.formSelectOption(proj.project_cd||'~'||'National Project (e.g., '||nproj_name, cattributes => 'VALUE='||proj.min_pk_isn);
		end if;
	END LOOP;
ELSE
	FOR proj IN cproj LOOP
        	htp.formSelectOption(proj.project_cd||'~'||proj.project_name, cattributes => 'VALUE='||proj.pk_isn);
        	--htp.formSelectOption(proj.name, cattributes => 'VALUE='||proj.pk_isn);
	END LOOP;
END IF;


HTP.FormSelectClose;
htp.print('</font><font face="Arial"><br><INPUT TYPE="button" VALUE="Select" onclick="passback(''PROJ'')"> <INPUT TYPE="button" VALUE="Cancel" onclick="Close_Onclick()"></font>' );
htp.formclose;
htp.bodyClose;
htp.htmlClose;
END;
/
SHOW ERRORS;